/*
Main stepper, this will run on the camera board and be used to control the stepper that runs up and down
*/


// THIS WAS MADE TO USE STEPPER MOTORS, YOU WILL HAVE TO ALTER IT
// MAKE SURE TO SET THE NETWORK NAME TO WHAT YOU WANT IT, IT IS THE URL
// SOME OF THESE COMMENTS WERE MADE FOR THE STEPPER, YOU CAN MOSTLY DISREGARD THEM
// PLEASE READ THROUGH THEM ALL THOUGH
#include <Arduino.h>
#include <WiFi.h>
#include <Stepper.h>
#include <ESPmDNS.h>
#include <HTTPClient.h>


// Stepper Motor Settings
const int stepsPerRevolution = 200;  // works for my stepper might need to change this if your copying, its just the amount of steps required to do a 360
#define DIR 0
#define STEP 1
int movedsteps = 0;

// PLEASE CHANGE THIS IT BREAKS EVERYTHING IF YOU DONT
// This controls the hostname you connect to, so for this it would be joystick.local and it would show the joystick
// PLEASE CHANGE IT

const char* networkname = "maestro";
const char* ssid = "EngineeringStudent";
const char* password = "cls2024!";

// start the server
WiFiServer server(80);

// the parameters the call will send
const char* PARAM_INPUT_2 = "left";
const char* PARAM_INPUT_1 = "up";
// Variables to save values from HTML form
int horsteps;
int versteps;
// Variable to detect whether a new request occurred
bool newRequest = false;

// HTML to build the web page, if i could hide it i would, there is a thing called spiffs but that takes longer to set up so im avoiding it
const char index_html[] PROGMEM = R"rawliteral(
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Interactive Joystick</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      text-align: center;
      margin: 0;
      padding: 0;
    }

    .joystick {
      width: 150px;
      height: 150px;
      border: 2px solid black;
      border-radius: 50%;
      position: relative;
      margin: 50px auto;
    }

    .joystick-knob {
      width: 40px;
      height: 40px;
      background-color: gray;
      border-radius: 50%;
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      cursor: grab;
    }

    .output {
      margin: 20px;
      font-size: 18px;
    }
  </style>
</head>
<body>

<h1>Interactive Joystick</h1>
<div class="joystick">
  <div class="joystick-knob"></div>
</div>

<div class="output">
  X: <span id="xValue">0</span> | Y: <span id="yValue">0</span>
</div>

<script>
  const joystick = document.querySelector('.joystick');
  const knob = document.querySelector('.joystick-knob');
  const xOutput = document.getElementById('xValue');
  const yOutput = document.getElementById('yValue');

  let isDragging = false;
  let centerX, centerY, radius;
  let lastX = 0;
  let lastY = 0;
  let lastSentTime = 0;

  const updateJoystickPosition = (x, y) => {
    const rect = joystick.getBoundingClientRect();
    centerX = rect.left + rect.width / 2;
    centerY = rect.top + rect.height / 2;
    radius = rect.width / 2 - knob.offsetWidth / 2;

    const dx = x - centerX;
    const dy = y - centerY;

    const distance = Math.min(radius, Math.sqrt(dx * dx + dy * dy));
    const angle = Math.atan2(dy, dx);

    const xPos = distance * Math.cos(angle);
    const yPos = distance * Math.sin(angle);

    knob.style.transform = `translate(${xPos}px, ${yPos}px)`;

    // Map x to -100 to 100 and y to -45 to 45
    const mappedX = Math.round((xPos / radius) * 60);
    const mappedY = Math.round((-yPos / radius) * 45);

    xOutput.textContent = mappedX;
    yOutput.textContent = mappedY;

    const currentTime = Date.now();

    if ((mappedX !== lastX || mappedY !== lastY) && currentTime - lastSentTime >= 200) {
      lastX = mappedX;
      lastY = mappedY;
      lastSentTime = currentTime;
      sendToESP32(mappedX, mappedY);
    }
  };

  const resetJoystick = () => {
    knob.style.transform = 'translate(-50%, -50%)';
    xOutput.textContent = '0';
    yOutput.textContent = '0';
    lastX = 0;
    lastY = 0;
    sendToESP32(0, 0);
  };

  const sendToESP32 = (x, y) => {
    const formData = new FormData();
    const formDatabase = new FormData();
    formDatabase.append('steps', x);
    formData.append('steps', y);

    fetch('/', {
      method: 'POST',
      body: formData
    }).catch(err => console.error('Failed to send data to ESP32:', err));
    fetch("http://maestro2.local", {
      method: 'POST',
      body: formData
    }).catch(err => console.error('Failed to send data to ESP32:', err));
  };

  const startDrag = (event) => {
    isDragging = true;
    const touch = event.touches ? event.touches[0] : event;
    updateJoystickPosition(touch.clientX, touch.clientY);
  };

  const moveDrag = (event) => {
    if (isDragging) {
      const touch = event.touches ? event.touches[0] : event;
      updateJoystickPosition(touch.clientX, touch.clientY);
    }
  };

  const endDrag = () => {
    if (isDragging) {
      isDragging = false;
      resetJoystick();
    }
  };

  knob.addEventListener('mousedown', startDrag);
  knob.addEventListener('touchstart', startDrag);

  window.addEventListener('mousemove', moveDrag);
  window.addEventListener('touchmove', moveDrag);

  window.addEventListener('mouseup', endDrag);
  window.addEventListener('touchend', endDrag);
</script>

</body>
</html>

)rawliteral";


void setup() {
  // thise code acts as the main server, please change the ssid and password to something that more suits your needs, i just set it that
  // since I needed something and that seemed to work
  // this is setup to connect to the engineering student network,
  Serial.begin(115200);
  WiFi.begin(ssid, password);
  Serial.print("Connecting to WiFi");
  while (WiFi.status() != WL_CONNECTED) {
    Serial.print(".");
    delay(500);
  }
  if (!MDNS.begin(networkname)) {  // Set the hostname to "esp32.local"
    Serial.println("Error setting up MDNS responder!");
    while (1) {
      delay(1000);
    }
  }
  Serial.println("");
  Serial.print(networkname);
  Serial.print(".local");
  pinMode(STEP, OUTPUT);
  pinMode(DIR, OUTPUT);
  server.begin();
}


void handleGetRequest(WiFiClient& client) {
  Serial.println("client got");
  client.print("HTTP/1.1 200 OK\r\n");
  client.print("Access-Control-Allow-Origin: *\r\n");
  client.print("Content-Type: text/html\r\n");
  client.print("Connection: close\r\n\r\n");
  client.print(index_html);
}

void handlePostRequest(WiFiClient& client, String request) {
  String body = "";

  // Read the body after headers
  while (client.available()) {
    char c = client.read();
    body += c;
  }
  // Extract 'left' parameter
  if (body.indexOf("name=\"steps\"") != -1) {
    int start = body.indexOf("name=\"steps\"") + 4;
    start = body.indexOf("\r\n", start);
    int end = body.indexOf("\r\n", start);
    versteps = body.substring(start, end).toInt();
    Serial.print("Number of steps steps set to: ");
    Serial.println(versteps);
  } else {
    Serial.println("Parameter 'steps' not found!");
  }
  client.print("HTTP/1.1 200 OK\r\n");
  client.print("Connection: close\r\n\r\n");
  client.stop();
}





void loop() {
  WiFiClient client = server.available();  // Check for incoming client
  if (client) {
    String request = "";
    while (client.connected() && client.available()) {
      char c = client.read();
      request += c;
      if (c == '\n' && request.endsWith("\r\n\r\n")) {
        break;  // End of request
      }
    }

    if (request.startsWith("GET /")) {
      handleGetRequest(client);
    } else if (request.startsWith("POST /")) {
      handlePostRequest(client, request);
    }
  }
  delay(25);
}
/* unused
void loop() {
  // Check if there was a new request and move the stepper accordingly
  if (newRequest) {
    for (int x = 0; x <= versteps.toInt(); x++) {
      digitalWrite(STEP, HIGH);
      delayMicroseconds(1500);
      digitalWrite(STEP, LOW);
      delayMicroseconds(1500);
    }                                     
    if (movedsteps > horsteps.toInt()) {  // move down
      digitalWrite(DIR, LOW);
      while (movedsteps > horsteps.toInt()) {
        digitalWrite(STEP, HIGH);
        delayMicroseconds(1500);
        digitalWrite(STEP, LOW);
        delayMicroseconds(1500);
        movedsteps--;
      }
    } else if (movedsteps < horsteps.toInt()) {  // move up
      digitalWrite(DIR, HIGH);
      while (movedsteps < horsteps.toInt()) {
        digitalWrite(STEP, HIGH);
        delayMicroseconds(1500);
        digitalWrite(STEP, LOW);
        delayMicroseconds(1500);
        movedsteps++;
      }
    }
    movedsteps = horsteps.toInt();
    newRequest = false;
  }
  delay(100);
}

*/

/* 
void sendPostRequest() {
  WiFiClient client;
  Serial.println(MDNS.queryHost("maestro2.local"));
  if (client.connect(MDNS.queryHost("maestro2"), 80)) {
    Serial.println("Connected to maestro2!");

    // Construct POST request
    String postData = "steps=100";
    String postRequest = String("POST / HTTP/1.1\r\n") + "Host: " + String(80) + "\r\n" + "Content-Type: application/x-www-form-urlencoded\r\n" + "Content-Length: " + String(postData.length()) + "\r\n" + "Connection: close\r\n\r\n" + postData;

    // Send request
    client.print(postRequest);
    Serial.println("POST request sent:");
    Serial.println(postRequest);
  } else {
    Serial.println("Failed to connect to maestro2.");
  }

  client.stop();
}
*/